//+------------------------------------------------------------------+
//|                                         BmpButtonTransparent.mqh |
//|                                           Copyright 2015, MigVRN |
//|                                                    Miguzov@bk.ru |
//+------------------------------------------------------------------+
#include <Controls\WndObj.mqh>
#include <ChartObjects\ChartObjectsBmpControls.mqh>
//+------------------------------------------------------------------+
//|   Class CWndObj with transparent background                      |
//+------------------------------------------------------------------+
class CWndTransparent : public CWndObj
  {
protected:
   bool              m_T[];
   int               m_SizeX;
   int               m_SizeY;
   ENUM_BASE_CORNER  m_corner;

public:
                     CWndTransparent(void) {};
                    ~CWndTransparent(void) {};
   bool              SetTransparent(const string name);
   bool              GetTransparent(int x,int y);
   bool              GetWidthAndHeightBmp(const string name,uint &width,uint &height);

protected:
   bool              OnMouseEvent(const int x,const int y,const int flags);
   bool              Create(const long chart,const string name,const int subwin,const int x1,const int y1,const int x2,const int y2);
   double            GetR(uint aColor);
   double            GetG(uint aColor);
   double            GetB(uint aColor);
   double            GetAlfa(uint  aColor);
  };
//+------------------------------------------------------------------+
//|                                                    IncColors.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|Get red color ARGB                                                |
//+------------------------------------------------------------------+
double CWndTransparent::GetR(uint aColor)
  {
   return(aColor&0xff);
  }
//+------------------------------------------------------------------+
//|Get green color ARGB                                              |
//+------------------------------------------------------------------+
double CWndTransparent::GetG(uint aColor)
  {
   return((aColor>>8)&0xff);
  }
//+------------------------------------------------------------------+
//|Get blue color ARGB                                               |
//+------------------------------------------------------------------+
double CWndTransparent::GetB(uint aColor)
  {
   return((aColor>>16)&0xff);
  }
//+------------------------------------------------------------------+
//|Get transparent ARGB                                              |
//+------------------------------------------------------------------+
double CWndTransparent::GetAlfa(uint  aColor)
  {
   return((aColor>>24)&0xff);
  }
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//|   Get width and height button
//+------------------------------------------------------------------+
bool CWndTransparent::GetWidthAndHeightBmp(const string name,uint &width,uint &height)
  {
   uint data[];
   ResourceReadImage(name,data,width,height);
   return(true);
  }
//+------------------------------------------------------------------+
//|   Set transparent of rectangle button
//+------------------------------------------------------------------+
bool CWndTransparent::SetTransparent(const string name)
  {
   uint data[];
   uint width;
   uint height;

   if(!ResourceReadImage(name,data,width,height))
     {
      ArrayResize(data,width*height);
      ResourceReadImage(name,data,width,height);
     }

   m_SizeX = (int)width;
   m_SizeY = (int)height;

   ArrayResize(m_T,m_SizeX*m_SizeY);

   for(uint y=0;y<(uint)m_SizeY;y++)
      for(uint x=0;x<(uint)m_SizeX;x++)
        {
         double alfa=GetAlfa(data[y*m_SizeX+x]);
         if(alfa>250)
           {
            m_T[y*m_SizeX+x]=true;
           }
         else
           {
            m_T[y*m_SizeX+x]=false;
           }
        }

   return(true);
  }
//+------------------------------------------------------------------+
//|  Get transparent of point                                        |
//+------------------------------------------------------------------+
bool CWndTransparent::GetTransparent(int x,int y)
  {
   int cor_x = Left();
   int cor_y = Top();

   switch(m_corner)
     {
      case CORNER_LEFT_UPPER:
        {
         break;
        }
      case CORNER_LEFT_LOWER:
        {
         cor_y=(int)ChartGetInteger(m_chart_id,CHART_HEIGHT_IN_PIXELS,m_subwin)-Top();
         break;
        }
      case CORNER_RIGHT_LOWER:
        {
         cor_x = (int)ChartGetInteger(m_chart_id,CHART_WIDTH_IN_PIXELS,m_subwin)-Left();
         cor_y = (int)ChartGetInteger(m_chart_id,CHART_HEIGHT_IN_PIXELS,m_subwin)-Top();
         break;
        }
      case CORNER_RIGHT_UPPER:
        {
         cor_x=(int)ChartGetInteger(m_chart_id,CHART_WIDTH_IN_PIXELS,m_subwin)-Left();
         break;
        }
     }

   if(x-cor_x<0 || y-cor_y<0)
      return(false);

   if(m_SizeX<=x-cor_x || m_SizeY<=y-cor_y)
      return(false);

   if(y<0 || y>ChartGetInteger(m_chart_id,CHART_HEIGHT_IN_PIXELS,m_subwin))
      return(false);

   if(x<0 || x>ChartGetInteger(m_chart_id,CHART_WIDTH_IN_PIXELS,m_subwin))
      return(false);

   if(m_T[(y-cor_y)*m_SizeX+(x-cor_x)]==true)
      return(true);

   return(false);
  }
//+------------------------------------------------------------------+
//| Create   
//+------------------------------------------------------------------+
bool CWndTransparent::Create(const long chart,const string name,const int subwin,const int x1,const int y1,const int x2,const int y2)
  {
   m_SizeX = 1;
   m_SizeY = 1;
   ArrayResize(m_T,m_SizeX*m_SizeY);
   return(CWnd::Create(chart,name,subwin,x1,y1,x2,y2));
  }
//+------------------------------------------------------------------+
//| Common handler of mouse events                                   |
//+------------------------------------------------------------------+
bool CWndTransparent::OnMouseEvent(const int x,const int y,const int flags)
  {
   if(!GetTransparent(x,y))
     {
      //--- if cursor is not inside the element and this element is active - deactivate
      if(IS_ACTIVE)
        {
         //--- reset state and coordinates
         m_mouse_x    =0;
         m_mouse_y    =0;
         m_mouse_flags=MOUSE_INVALID_FLAGS;
         //--- deactivate
         Deactivate();
        }
      return(false);
     }

//--- check the state of the left mouse button
   if((flags&MOUSE_LEFT)!=0)
     {
      //--- left mouse button is pressed
      if(m_mouse_flags==MOUSE_INVALID_FLAGS)
        {
         //--- but not in this control (i.e., cursor entered the element with mouse button pressed)
         //--- activate the control, but there will be no click
         if(!IS_ACTIVE)
           {
            //--- generate event
            EventChartCustom(m_chart_id,ON_MOUSE_FOCUS_SET,m_id,0.0,m_name);
            //--- activate
            return(Activate());
           }
         return(true);
        }
      if((m_mouse_flags&MOUSE_LEFT)!=0)
        {
         //--- mouse button has already been pressed
         if(IS_CAN_DRAG)
            return(OnDragProcess(x,y));
         if(IS_CLICKS_BY_PRESS)
           {
            EventChartCustom(m_chart_id,ON_CLICK,m_id,0.0,m_name);
            //--- handled
            return(true);
           }
        }
      else
        {
         //--- mouse button has been released (pressing)
         //--- save the state and coordinates
         m_mouse_flags=flags;
         m_mouse_x    =x;
         m_mouse_y    =y;
         //--- call the handler
         return(OnMouseDown());
        }
     }
   else
     {
      //--- left mouse button is released
      if(m_mouse_flags==MOUSE_INVALID_FLAGS)
        {
         //--- cursor entered the control with mouse button released
         //--- activate control and save state to the member
         m_mouse_flags=flags;
         //--- generate event
         EventChartCustom(m_chart_id,ON_MOUSE_FOCUS_SET,m_id,0.0,m_name);
         //--- activate
         return(Activate());
        }
      if((m_mouse_flags&MOUSE_LEFT)!=0)
        {
         //--- mouse button has been pressed (clicking)
         //--- save the state and coordinates
         m_mouse_flags=flags;
         m_mouse_x    =x;
         m_mouse_y    =y;
         //--- call the handler
         return(OnMouseUp());
        }
     }
//--- handled
   return(true);
  }
//+------------------------------------------------------------------+
//| Class CBmpButtonTransparent                                      |
//| Usage: control that is displayed by                              |
//|      the CChartObjectBmpLabel object with transparent background |
//+------------------------------------------------------------------+
class CBmpButtonTransparent : public CWndTransparent
  {
private:

   CChartObjectBmpLabel m_button;           // chart object
   //--- parameters of the chart object
   int               m_border;              // border width
   bool              m_state_button;        // state of button
   string            m_bmp_name;            // name of BMP file for the "OFF" and "ON" state 
   string            m_bmp_off_passive_name;
   string            m_bmp_off_active_name;
   string            m_bmp_on_passive_name;
   string            m_bmp_on_active_name;

public:
                     CBmpButtonTransparent(void);
                    ~CBmpButtonTransparent(void);
   //--- create
   virtual bool      Create(const long chart,const string name,const int subwin,const int x1,const int y1,const int x2,const int y2);

   //--- parameters of the chart object
   int               Border(void) const { return(m_border);}
   bool              Border(const int value);

   bool              BmpNames(const string name);
   string            BmpName(void) const { return(m_bmp_name);}
   bool              BmpName(const string name);
   string            BmpOffPassiveName(void) const { return(m_bmp_off_passive_name);}
   bool              BmpOffPassiveName(const string name);
   string            BmpOffActiveName(void) const {return(m_bmp_off_active_name);}
   bool              BmpOffActiveName(const string name);

   string            BmpOnPassiveName(void) const { return(m_bmp_on_passive_name);}
   bool              BmpOnPassiveName(const string name);
   string            BmpOnActiveName(void) const { return(m_bmp_on_active_name);}
   bool              BmpOnActiveName(const string name);

   //--- state
   bool              Pressed(void) const { return(m_state_button);}
   bool              Pressed(const bool pressed);
   bool              Press(void);
   bool              RefreshBmp();

   //--- properties
   bool              Locking(void) const { return(IS_CAN_LOCK);                }
   void              Locking(const bool locking);

   bool              SetCorner(ENUM_BASE_CORNER chart_corner) {m_corner=chart_corner; return(m_button.Corner(chart_corner));}

protected:
   //--- handlers of object settings
   virtual bool      OnSetZOrder(void) { return(m_button.Z_Order(m_zorder)); }

   //--- internal event handlers
   virtual bool      OnCreate(void);
   virtual bool      OnShow(void);
   virtual bool      OnHide(void);
   virtual bool      OnMove(void);
   virtual bool      OnChange(void);

   virtual bool      OnActivate(void);
   virtual bool      OnDeactivate(void);
   virtual bool      OnMouseDown(void);
   virtual bool      OnMouseUp(void);

  };
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
CBmpButtonTransparent::CBmpButtonTransparent(void) : m_border(0),
                                                     m_state_button(false),
                                                     m_bmp_name(NULL),
                                                     m_bmp_off_passive_name(NULL),
                                                     m_bmp_off_active_name(NULL),
                                                     m_bmp_on_passive_name(NULL),
                                                     m_bmp_on_active_name(NULL)
  {
  }
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
CBmpButtonTransparent::~CBmpButtonTransparent(void)
  {
  }
//+------------------------------------------------------------------+
//| Create a control                                                 |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::Create(const long chart,const string name,const int subwin,const int x1,const int y1,const int x2,const int y2)
  {
//--- call method of the parent class
   if(!CWndTransparent::Create(chart,name,subwin,x1,y1,x2,y2))
      return(false);
//--- create the chart object
   if(!m_button.Create(chart,name,subwin,x1,y1))
      return(false);
//--- call the settings handler
   return(OnChange());
  }
//+------------------------------------------------------------------+
//| Set border width                                                 |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::Border(const int value)
  {
//--- save new value of parameter
   m_border=value;
//--- set up the chart object
   return(m_button.Width(value));
  }
//+------------------------------------------------------------------+
//| Set image                                                        |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpNames(const string name)
  {
//--- save new values of parameters
   m_bmp_name=name;
//--- set up the chart object
   if(!m_button.BmpFileOn(name))
      return(false);
   if(!m_button.BmpFileOff(name))
      return(false);
   ChartRedraw();
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set image for the "OFF" and "ON" state                           |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpName(const string name)
  {
//--- save new value of parameter
   m_bmp_name=name;
//--- set up the chart object
   if(!m_button.BmpFileOn(name))
      return(false);
   if(!m_button.BmpFileOff(name))
      return(false);
//--- set size by image dimensions
   Width(m_button.X_Size());
   Height(m_button.Y_Size());

   ChartRedraw();
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set image for the "OFF" state (passive)                          |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpOffPassiveName(const string name)
  {
//--- save new value of parameter
   m_bmp_off_passive_name=name;
//--- set up the chart object
   if(!IS_ACTIVE)
      return(BmpName(name));
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set image for the "OFF" state (active)                           |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpOffActiveName(const string name)
  {
//--- save new value of parameter
   m_bmp_off_active_name=name;
//--- set up the chart object
   if(IS_ACTIVE)
      return(BmpName(name));
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set image for the "ON" state (passive)                           |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpOnPassiveName(const string name)
  {
//--- save new value of parameter
   m_bmp_on_passive_name=name;
//--- set up the chart object
   if(IS_ACTIVE)
      return(BmpName(name));
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Set image for the "ON" state (active)                            |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::BmpOnActiveName(const string name)
  {
//--- save new value of parameter
   m_bmp_on_active_name=name;
//--- set up the chart object
   if(!IS_ACTIVE)
      return(BmpName(name));
//--- succeed
   return(true);
  }
//+------------------------------------------------------------------+
//| Locking flag                                                     |
//+------------------------------------------------------------------+
void CBmpButtonTransparent::Locking(const bool flag)
  {
   if(flag)
      PropFlagsSet(WND_PROP_FLAG_CAN_LOCK);
   else
      PropFlagsReset(WND_PROP_FLAG_CAN_LOCK);
  }
//+------------------------------------------------------------------+
//| Create object on chart                                           |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnCreate(void)
  {
//--- create the chart object by previously set parameters
   return(m_button.Create(m_chart_id,m_name,m_subwin,m_rect.left,m_rect.top));
  }
//+------------------------------------------------------------------+
//| Display object on chart                                          |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnShow(void)
  {
   return(m_button.Timeframes(OBJ_ALL_PERIODS));
  }
//+------------------------------------------------------------------+
//| Hide object from chart                                           |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnHide(void)
  {
   return(m_button.Timeframes(OBJ_NO_PERIODS));
  }
//+------------------------------------------------------------------+
//| Absolute movement of the chart object                            |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnMove(void)
  {
//--- position the chart object
   return(m_button.X_Distance(m_rect.left) && m_button.Y_Distance(m_rect.top));
  }
//+------------------------------------------------------------------+
//| Set up the chart object                                          |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnChange(void)
  {
//--- set up the chart object
   return(m_button.Width(m_border) &&
          m_button.BmpFileOn(m_bmp_name) &&
          m_button.BmpFileOff(m_bmp_name));
  }
//+------------------------------------------------------------------+
//| Handler of activating the group of controls                      |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnActivate(void)
  {
   if(!Pressed())
     {
      if(m_bmp_off_active_name!=NULL)
         BmpName(m_bmp_off_active_name);
     }
   else
     {
      if(m_bmp_on_active_name!=NULL)
         BmpName(m_bmp_on_active_name);
     }
   return(true);
  }
//+------------------------------------------------------------------+
//| Handler of deactivating the group of controls                    |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnDeactivate(void)
  {
   if(!Pressed())
     {
      if(m_bmp_off_passive_name!=NULL)
         BmpName(m_bmp_off_passive_name);
     }
   else
     {
      if(m_bmp_on_passive_name!=NULL)
         BmpName(m_bmp_on_passive_name);
     }

   if(!IS_CAN_LOCK)
      Pressed(false);

   return(true);
  }
//+------------------------------------------------------------------+
//| Set actual Bmp file                                              |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::RefreshBmp(void)
  {
   if(Pressed())
     {
      if(IS_ACTIVE)
        {
         if(m_bmp_on_active_name!=NULL)
            BmpName(m_bmp_on_active_name);
        }
      else
        {
         if(m_bmp_on_passive_name!=NULL)
            BmpName(m_bmp_on_passive_name);
        }
     }
   else
     {
      if(IS_ACTIVE)
        {
         if(m_bmp_off_active_name!=NULL)
            BmpName(m_bmp_off_active_name);
        }
      else
        {
         if(m_bmp_off_passive_name!=NULL)
            BmpName(m_bmp_off_passive_name);
        }
     }

   OnChange();

   return(true);
  }
//+------------------------------------------------------------------+
//| Press button                                                     |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::Press(void)
  {
   m_state_button=!Pressed();
   RefreshBmp();
   return(true);
  }
//+------------------------------------------------------------------+
//| Set state button                                                 |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::Pressed(const bool pressed)
  {
   m_state_button=pressed;
   RefreshBmp();
   return(true);
  }
//+------------------------------------------------------------------+
//| Handler of click on the left mouse button                        |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnMouseDown(void)
  {
   if(!IS_CAN_LOCK)
     {
      Pressed(true);
     }
//--- call of the method of the parent class
   return(CWnd::OnMouseDown());
  }
//+------------------------------------------------------------------+
//| Handler of click on the left mouse button                        |
//+------------------------------------------------------------------+
bool CBmpButtonTransparent::OnMouseUp(void)
  {
//--- depress the button if it is not fixed
   if(m_state_button && !IS_CAN_LOCK)
     {
      Pressed(true);
     }
//--- call of the method of the parent class
   return(CWnd::OnMouseUp());
  }
//+------------------------------------------------------------------+
